/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.user;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.muc.InvitationListener;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatManager;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.jivesoftware.smackx.workgroup.MetaData;
import org.jivesoftware.smackx.workgroup.WorkgroupInvitation;
import org.jivesoftware.smackx.workgroup.WorkgroupInvitationListener;
import org.jivesoftware.smackx.workgroup.ext.forms.WorkgroupForm;
import org.jivesoftware.smackx.workgroup.packet.DepartQueuePacket;
import org.jivesoftware.smackx.workgroup.packet.QueueUpdate;
import org.jivesoftware.smackx.workgroup.packet.SessionID;
import org.jivesoftware.smackx.workgroup.packet.UserID;
import org.jivesoftware.smackx.workgroup.settings.ChatSetting;
import org.jivesoftware.smackx.workgroup.settings.ChatSettings;
import org.jivesoftware.smackx.workgroup.settings.OfflineSettings;
import org.jivesoftware.smackx.workgroup.settings.SoundSettings;
import org.jivesoftware.smackx.workgroup.settings.WorkgroupProperties;
import org.jivesoftware.smackx.workgroup.user.QueueListener;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdata.form.FillableForm;
import org.jivesoftware.smackx.xdata.form.Form;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityJid;
import org.jxmpp.jid.Jid;

public class Workgroup {
    private final EntityBareJid workgroupJID;
    private final XMPPConnection connection;
    private boolean inQueue;
    private final CopyOnWriteArraySet<WorkgroupInvitationListener> invitationListeners;
    private final CopyOnWriteArraySet<QueueListener> queueListeners;
    private int queuePosition = -1;
    private int queueRemainingTime = -1;

    public Workgroup(EntityBareJid workgroupJID, XMPPConnection connection) {
        if (!connection.isAuthenticated()) {
            throw new IllegalStateException("Must login to server before creating workgroup.");
        }
        this.workgroupJID = workgroupJID;
        this.connection = connection;
        this.inQueue = false;
        this.invitationListeners = new CopyOnWriteArraySet();
        this.queueListeners = new CopyOnWriteArraySet();
        this.addQueueListener(new QueueListener(){

            @Override
            public void joinedQueue() {
                Workgroup.this.inQueue = true;
            }

            @Override
            public void departedQueue() {
                Workgroup.this.inQueue = false;
                Workgroup.this.queuePosition = -1;
                Workgroup.this.queueRemainingTime = -1;
            }

            @Override
            public void queuePositionUpdated(int currentPosition) {
                Workgroup.this.queuePosition = currentPosition;
            }

            @Override
            public void queueWaitTimeUpdated(int secondsRemaining) {
                Workgroup.this.queueRemainingTime = secondsRemaining;
            }
        });
        MultiUserChatManager.getInstanceFor(connection).addInvitationListener(new InvitationListener(){

            @Override
            public void invitationReceived(XMPPConnection conn, MultiUserChat room, EntityJid inviter, String reason, String password, Message message, MUCUser.Invite invitation) {
                Workgroup.this.inQueue = false;
                Workgroup.this.queuePosition = -1;
                Workgroup.this.queueRemainingTime = -1;
            }
        });
        StanzaTypeFilter typeFilter = new StanzaTypeFilter(Message.class);
        connection.addAsyncStanzaListener(new StanzaListener(){

            @Override
            public void processStanza(Stanza packet) {
                Workgroup.this.handlePacket(packet);
            }
        }, typeFilter);
    }

    public EntityBareJid getWorkgroupJID() {
        return this.workgroupJID;
    }

    public boolean isInQueue() {
        return this.inQueue;
    }

    public boolean isAvailable() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Presence directedPresence = ((PresenceBuilder)this.connection.getStanzaFactory().buildPresenceStanza().ofType(Presence.Type.available).to(this.workgroupJID)).build();
        StanzaTypeFilter typeFilter = new StanzaTypeFilter(Presence.class);
        FromMatchesFilter fromFilter = FromMatchesFilter.create(this.workgroupJID);
        StanzaCollector collector = this.connection.createStanzaCollectorAndSend(new AndFilter(fromFilter, typeFilter), directedPresence);
        Presence response = (Presence)collector.nextResultOrThrow();
        return Presence.Type.available == response.getType();
    }

    public int getQueuePosition() {
        return this.queuePosition;
    }

    public int getQueueRemainingTime() {
        return this.queueRemainingTime;
    }

    public void joinQueue() throws XMPPException, SmackException, InterruptedException {
        this.joinQueue(null);
    }

    public void joinQueue(FillableForm answerForm) throws XMPPException, SmackException, InterruptedException {
        this.joinQueue(answerForm.getDataFormToSubmit(), null);
    }

    public void joinQueue(DataForm answerForm, Jid userID) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        if (this.inQueue) {
            throw new IllegalStateException("Already in queue " + String.valueOf(this.workgroupJID));
        }
        JoinQueuePacket joinPacket = new JoinQueuePacket(this.workgroupJID, answerForm, userID);
        this.connection.sendIqRequestAndWaitForResponse(joinPacket);
        this.fireQueueJoinedEvent();
    }

    public void joinQueue(Map<String, Object> metadata, Jid userID) throws XMPPException, SmackException, InterruptedException {
        if (this.inQueue) {
            throw new IllegalStateException("Already in queue " + String.valueOf(this.workgroupJID));
        }
        DataForm.Builder form = DataForm.builder();
        for (String name : metadata.keySet()) {
            String value = metadata.get(name).toString();
            TextSingleFormField.Builder field2 = FormField.builder(name);
            field2.setValue(value);
            form.addField(field2.build());
        }
        this.joinQueue(form.build(), userID);
    }

    public void departQueue() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        if (!this.inQueue) {
            return;
        }
        DepartQueuePacket departPacket = new DepartQueuePacket(this.workgroupJID);
        this.connection.sendIqRequestAndWaitForResponse(departPacket);
        this.fireQueueDepartedEvent();
    }

    public void addQueueListener(QueueListener queueListener) {
        this.queueListeners.add(queueListener);
    }

    public void removeQueueListener(QueueListener queueListener) {
        this.queueListeners.remove(queueListener);
    }

    public void addInvitationListener(WorkgroupInvitationListener invitationListener) {
        this.invitationListeners.add(invitationListener);
    }

    public void removeQueueListener(WorkgroupInvitationListener invitationListener) {
        this.invitationListeners.remove(invitationListener);
    }

    private void fireInvitationEvent(WorkgroupInvitation invitation) {
        for (WorkgroupInvitationListener listener : this.invitationListeners) {
            listener.invitationReceived(invitation);
        }
    }

    private void fireQueueJoinedEvent() {
        for (QueueListener listener : this.queueListeners) {
            listener.joinedQueue();
        }
    }

    private void fireQueueDepartedEvent() {
        for (QueueListener listener : this.queueListeners) {
            listener.departedQueue();
        }
    }

    private void fireQueuePositionEvent(int currentPosition) {
        for (QueueListener listener : this.queueListeners) {
            listener.queuePositionUpdated(currentPosition);
        }
    }

    private void fireQueueTimeEvent(int secondsRemaining) {
        for (QueueListener listener : this.queueListeners) {
            listener.queueWaitTimeUpdated(secondsRemaining);
        }
    }

    private void handlePacket(Stanza packet) {
        if (packet instanceof Message) {
            Message msg = (Message)packet;
            XmlElement pe = msg.getExtensionElement("depart-queue", "http://jabber.org/protocol/workgroup");
            XmlElement queueStatus = msg.getExtensionElement("queue-status", "http://jabber.org/protocol/workgroup");
            if (pe != null) {
                this.fireQueueDepartedEvent();
            } else if (queueStatus != null) {
                QueueUpdate queueUpdate = (QueueUpdate)queueStatus;
                if (queueUpdate.getPosition() != -1) {
                    this.fireQueuePositionEvent(queueUpdate.getPosition());
                }
                if (queueUpdate.getRemaingTime() != -1) {
                    this.fireQueueTimeEvent(queueUpdate.getRemaingTime());
                }
            } else {
                MUCUser.Invite invite;
                MUCUser mucUser = MUCUser.from(msg);
                MUCUser.Invite invite2 = invite = mucUser != null ? mucUser.getInvite() : null;
                if (invite != null && this.workgroupJID.equals(invite.getFrom())) {
                    String sessionID = null;
                    Map<String, List<String>> metaData = null;
                    pe = msg.getExtensionElement("session", "http://jivesoftware.com/protocol/workgroup");
                    if (pe != null) {
                        sessionID = ((SessionID)pe).getSessionID();
                    }
                    if ((pe = msg.getExtensionElement("metadata", "http://jivesoftware.com/protocol/workgroup")) != null) {
                        metaData = ((MetaData)pe).getMetaData();
                    }
                    WorkgroupInvitation inv = new WorkgroupInvitation(this.connection.getUser(), msg.getFrom(), this.workgroupJID, sessionID, msg.getBody(), msg.getFrom(), metaData);
                    this.fireInvitationEvent(inv);
                }
            }
        }
    }

    public ChatSetting getChatSetting(String key) throws XMPPException, SmackException, InterruptedException {
        ChatSettings chatSettings = this.getChatSettings(key, -1);
        return chatSettings.getFirstEntry();
    }

    public ChatSettings getChatSettings(int type) throws XMPPException, SmackException, InterruptedException {
        return this.getChatSettings(null, type);
    }

    public ChatSettings getChatSettings() throws XMPPException, SmackException, InterruptedException {
        return this.getChatSettings(null, -1);
    }

    private ChatSettings getChatSettings(String key, int type) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        ChatSettings request = new ChatSettings();
        if (key != null) {
            request.setKey(key);
        }
        if (type != -1) {
            request.setType(type);
        }
        request.setType(IQ.Type.get);
        request.setTo(this.workgroupJID);
        ChatSettings response = (ChatSettings)this.connection.sendIqRequestAndWaitForResponse(request);
        return response;
    }

    public boolean isEmailAvailable() throws SmackException, InterruptedException {
        ServiceDiscoveryManager discoManager = ServiceDiscoveryManager.getInstanceFor(this.connection);
        try {
            DomainBareJid workgroupService = this.workgroupJID.asDomainBareJid();
            DiscoverInfo infoResult = discoManager.discoverInfo(workgroupService);
            return infoResult.containsFeature("jive:email:provider");
        }
        catch (XMPPException e) {
            return false;
        }
    }

    public OfflineSettings getOfflineSettings() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        OfflineSettings request = new OfflineSettings();
        request.setType(IQ.Type.get);
        request.setTo(this.workgroupJID);
        return (OfflineSettings)this.connection.sendIqRequestAndWaitForResponse(request);
    }

    public SoundSettings getSoundSettings() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        SoundSettings request = new SoundSettings();
        request.setType(IQ.Type.get);
        request.setTo(this.workgroupJID);
        return (SoundSettings)this.connection.sendIqRequestAndWaitForResponse(request);
    }

    public WorkgroupProperties getWorkgroupProperties() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        WorkgroupProperties request = new WorkgroupProperties();
        request.setType(IQ.Type.get);
        request.setTo(this.workgroupJID);
        return (WorkgroupProperties)this.connection.sendIqRequestAndWaitForResponse(request);
    }

    public WorkgroupProperties getWorkgroupProperties(String jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        WorkgroupProperties request = new WorkgroupProperties();
        request.setJid(jid);
        request.setType(IQ.Type.get);
        request.setTo(this.workgroupJID);
        return (WorkgroupProperties)this.connection.sendIqRequestAndWaitForResponse(request);
    }

    public Form getWorkgroupForm() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        WorkgroupForm workgroupForm = new WorkgroupForm();
        workgroupForm.setType(IQ.Type.get);
        workgroupForm.setTo(this.workgroupJID);
        WorkgroupForm response = (WorkgroupForm)this.connection.sendIqRequestAndWaitForResponse(workgroupForm);
        return Form.from(response);
    }

    private final class JoinQueuePacket
    extends IQ {
        private final Jid userID;
        private final DataForm form;

        private JoinQueuePacket(EntityBareJid workgroup2, DataForm answerForm, Jid userID) {
            super("join-queue", "http://jabber.org/protocol/workgroup");
            this.userID = userID;
            this.setTo(workgroup2);
            this.setType(IQ.Type.set);
            this.form = answerForm;
            this.addExtension(this.form);
        }

        @Override
        protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
            buf.rightAngleBracket();
            buf.append("<queue-notifications/>");
            if (Workgroup.this.connection.isAnonymous()) {
                buf.append(new UserID(this.userID).toXML());
            }
            buf.append(this.form.toXML());
            return buf;
        }
    }
}

