/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dane;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class X509TrustManagerUtil {
    public static X509TrustManager getDefault() {
        return X509TrustManagerUtil.getDefault(null);
    }

    public static X509TrustManager getDefault(KeyStore keyStore) {
        TrustManagerFactory trustManagerFactory;
        String defaultAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(defaultAlgorithm);
            trustManagerFactory.init(keyStore);
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        throw new AssertionError((Object)("No trust manager for the default algorithm " + defaultAlgorithm + " found"));
    }
}

