/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.x509;

import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.californium.elements.util.Asn1DerDecoder;
import org.eclipse.californium.elements.util.CertPathUtil;
import org.eclipse.californium.elements.util.JceProviderUtil;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalSignature;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;
import org.eclipse.californium.scandium.util.ListUtils;

public class CertificateConfigurationHelper {
    private final List<PublicKey> keys = new ArrayList<PublicKey>();
    private final List<List<X509Certificate>> chains = new ArrayList<List<X509Certificate>>();
    private final List<X509Certificate> trusts = new ArrayList<X509Certificate>();
    private boolean clientUsage;
    private boolean serverUsage;
    private final List<SignatureAndHashAlgorithm> defaultSignatureAndHashAlgorithms = new ArrayList<SignatureAndHashAlgorithm>();
    private final List<XECDHECryptography.SupportedGroup> defaultSupportedGroups = new ArrayList<XECDHECryptography.SupportedGroup>();

    public void addConfigurationDefaultsFor(PublicKey key) {
        String algorithm = key.getAlgorithm();
        if (!JceProviderUtil.isSupported((String)algorithm)) {
            throw new IllegalArgumentException("Public key algorithm " + algorithm + " is not supported!");
        }
        if (Asn1DerDecoder.isEcBased((String)algorithm)) {
            XECDHECryptography.SupportedGroup group = XECDHECryptography.SupportedGroup.fromPublicKey(key);
            if (group == null) {
                throw new IllegalArgumentException("Public key's ec-group must be supported!");
            }
            ListUtils.addIfAbsent(this.defaultSupportedGroups, group);
        }
        SignatureAndHashAlgorithm.ensureSignatureAlgorithm(this.defaultSignatureAndHashAlgorithms, key);
        ListUtils.addIfAbsent(this.keys, key);
    }

    public void addConfigurationDefaultsFor(List<X509Certificate> certificateChain) {
        if (!certificateChain.isEmpty()) {
            X509Certificate certificate = certificateChain.get(0);
            this.addConfigurationDefaultsFor(certificate.getPublicKey());
            if (CertPathUtil.canBeUsedForAuthentication((X509Certificate)certificate, (boolean)false)) {
                this.serverUsage = true;
            }
            if (CertPathUtil.canBeUsedForAuthentication((X509Certificate)certificate, (boolean)true)) {
                this.clientUsage = true;
            }
            ListUtils.addIfAbsent(this.defaultSignatureAndHashAlgorithms, SignatureAndHashAlgorithm.getSignatureAlgorithms(certificateChain));
            for (int index = 1; index < certificateChain.size(); ++index) {
                certificate = certificateChain.get(index);
                PublicKey certPublicKey = certificate.getPublicKey();
                if (!Asn1DerDecoder.isEcBased((String)certPublicKey.getAlgorithm())) continue;
                XECDHECryptography.SupportedGroup group = XECDHECryptography.SupportedGroup.fromPublicKey(certPublicKey);
                if (group == null) {
                    throw new IllegalArgumentException("CA's public key ec-group must be supported!");
                }
                ListUtils.addIfAbsent(this.defaultSupportedGroups, group);
            }
            this.chains.add(certificateChain);
        }
    }

    public void addConfigurationDefaultsForTrusts(X509Certificate[] trusts) {
        if (trusts != null) {
            for (X509Certificate certificate : trusts) {
                this.addConfigurationDefaultsForTrusts(certificate.getPublicKey());
                this.trusts.add(certificate);
            }
        }
    }

    public void addConfigurationDefaultsForTrusts(PublicKey publicKey) {
        if (publicKey != null) {
            SignatureAndHashAlgorithm.ensureSignatureAlgorithm(this.defaultSignatureAndHashAlgorithms, publicKey);
            if (Asn1DerDecoder.isEcBased((String)publicKey.getAlgorithm())) {
                XECDHECryptography.SupportedGroup group = XECDHECryptography.SupportedGroup.fromPublicKey(publicKey);
                if (group == null) {
                    throw new IllegalArgumentException("CA's public key ec-group must be supported!");
                }
                ListUtils.addIfAbsent(this.defaultSupportedGroups, group);
            }
        }
    }

    public List<SignatureAndHashAlgorithm> getDefaultSignatureAndHashAlgorithms() {
        return this.defaultSignatureAndHashAlgorithms;
    }

    public List<XECDHECryptography.SupportedGroup> getDefaultSupportedGroups() {
        return this.defaultSupportedGroups;
    }

    public void verifySignatureAndHashAlgorithmsConfiguration(List<SignatureAndHashAlgorithm> algorithms) {
        for (PublicKey publicKey : this.keys) {
            if (SignatureAndHashAlgorithm.getSupportedSignatureAlgorithm(algorithms, publicKey) != null) continue;
            throw new IllegalStateException("supported signature and hash algorithms " + algorithms + " doesn't match the public " + publicKey.getAlgorithm() + " key!");
        }
        for (List list : this.chains) {
            if (SignatureAndHashAlgorithm.isSignedWithSupportedAlgorithms(algorithms, list)) continue;
            throw new IllegalStateException("supported signature and hash algorithms " + algorithms + " doesn't match the certificate chain!");
        }
        for (X509Certificate x509Certificate : this.trusts) {
            PublicKey publicKey = x509Certificate.getPublicKey();
            if (SignatureAndHashAlgorithm.getSupportedSignatureAlgorithm(algorithms, publicKey) != null) continue;
            throw new IllegalStateException("supported signature and hash algorithms " + algorithms + " doesn't match the trust's public key " + publicKey.getAlgorithm() + "!");
        }
    }

    public void verifySupportedGroupsConfiguration(List<XECDHECryptography.SupportedGroup> groups) {
        for (XECDHECryptography.SupportedGroup group : this.defaultSupportedGroups) {
            if (!group.isUsable()) {
                throw new IllegalStateException("public key used with unsupported group (curve) " + group.name() + "!");
            }
            if (groups.contains((Object)group)) continue;
            throw new IllegalStateException("public key used with not configured group (curve) " + group.name() + "!");
        }
    }

    public boolean canBeUsedForAuthentication(boolean client) {
        return this.chains.isEmpty() || (client ? this.clientUsage : this.serverUsage);
    }

    public void verifyKeyPair(PrivateKey privateKey, PublicKey publicKey) {
        String algorithm = publicKey.getAlgorithm();
        for (SignatureAndHashAlgorithm.SignatureAlgorithm signatureAlgorithm : SignatureAndHashAlgorithm.SignatureAlgorithm.values()) {
            if (!signatureAlgorithm.isSupported(algorithm)) continue;
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = new SignatureAndHashAlgorithm(SignatureAndHashAlgorithm.HashAlgorithm.INTRINSIC, signatureAlgorithm);
            if (!signatureAlgorithm.isIntrinsic()) {
                SignatureAndHashAlgorithm.HashAlgorithm hashAlgorithm;
                SignatureAndHashAlgorithm.HashAlgorithm[] hashAlgorithmArray = SignatureAndHashAlgorithm.HashAlgorithm.values();
                int n = hashAlgorithmArray.length;
                for (int i = 0; !(i >= n || SignatureAndHashAlgorithm.HashAlgorithm.INTRINSIC != (hashAlgorithm = hashAlgorithmArray[i]) && SignatureAndHashAlgorithm.HashAlgorithm.NONE != hashAlgorithm && (signatureAndHashAlgorithm = new SignatureAndHashAlgorithm(hashAlgorithm, signatureAlgorithm)).isSupported()); ++i) {
                }
            }
            if (!signatureAndHashAlgorithm.isSupported(publicKey)) continue;
            ThreadLocalSignature threadLocalSignature = signatureAndHashAlgorithm.getThreadLocalSignature();
            Signature signature = (Signature)threadLocalSignature.current();
            byte[] data = "Just a signature test".getBytes();
            try {
                signature.initSign(privateKey);
                signature.update(data);
                byte[] sign = signature.sign();
                signature.initVerify(publicKey);
                signature.update(data);
                if (signature.verify(sign)) {
                    return;
                }
                throw new IllegalArgumentException(publicKey.getAlgorithm() + " key pair is not valid!");
            }
            catch (GeneralSecurityException generalSecurityException) {
                break;
            }
        }
        throw new IllegalArgumentException(algorithm + " is not supported by the JCE!");
    }
}

