//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by validation-gen. DO NOT EDIT.

package typeargs

import (
	context "context"
	fmt "fmt"

	operation "k8s.io/apimachinery/pkg/api/operation"
	safe "k8s.io/apimachinery/pkg/api/safe"
	validate "k8s.io/apimachinery/pkg/api/validate"
	field "k8s.io/apimachinery/pkg/util/validation/field"
	primitives "k8s.io/code-generator/cmd/validation-gen/output_tests/primitives"
	testscheme "k8s.io/code-generator/cmd/validation-gen/testscheme"
)

func init() { localSchemeBuilder.Register(RegisterValidations) }

// RegisterValidations adds validation functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterValidations(scheme *testscheme.Scheme) error {
	scheme.AddValidationFunc((*T1)(nil), func(ctx context.Context, op operation.Operation, obj, oldObj interface{}, subresources ...string) field.ErrorList {
		if len(subresources) == 0 {
			return Validate_T1(ctx, op, nil /* fldPath */, obj.(*T1), safe.Cast[*T1](oldObj))
		}
		return field.ErrorList{field.InternalError(nil, fmt.Errorf("no validation found for %T, subresources: %v", obj, subresources))}
	})
	return nil
}

func Validate_E1(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *E1) (errs field.ErrorList) {
	// type E1
	errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, false, "type E1")...)

	return errs
}

func Validate_T1(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *T1) (errs field.ErrorList) {
	// field T1.TypeMeta has no validation

	// field T1.S1
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *primitives.T1) (errs field.ErrorList) {
			errs = append(errs, validate.FixedResult[*primitives.T1](ctx, op, fldPath, obj, oldObj, false, "T1.S1")...)
			errs = append(errs, primitives.Validate_T1(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("s1"), obj.S1, safe.Field(oldObj, func(oldObj *T1) *primitives.T1 { return oldObj.S1 }))...)

	// field T1.PS1
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *primitives.T1) (errs field.ErrorList) {
			errs = append(errs, validate.FixedResult[*primitives.T1](ctx, op, fldPath, obj, oldObj, false, "PT1.PS1")...)
			errs = append(errs, primitives.Validate_T1(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("ps1"), obj.PS1, safe.Field(oldObj, func(oldObj *T1) *primitives.T1 { return oldObj.PS1 }))...)

	// field T1.E1
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *E1) (errs field.ErrorList) {
			errs = append(errs, validate.FixedResult[*E1](ctx, op, fldPath, obj, oldObj, false, "T1.E1")...)
			errs = append(errs, Validate_E1(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("e1"), &obj.E1, safe.Field(oldObj, func(oldObj *T1) *E1 { return &oldObj.E1 }))...)

	// field T1.PE1
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *E1) (errs field.ErrorList) {
			errs = append(errs, validate.FixedResult[*E1](ctx, op, fldPath, obj, oldObj, true, "T1.PE1")...)
			errs = append(errs, Validate_E1(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("pe1"), obj.PE1, safe.Field(oldObj, func(oldObj *T1) *E1 { return oldObj.PE1 }))...)

	// field T1.I1
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *int) (errs field.ErrorList) {
			errs = append(errs, validate.FixedResult[*int](ctx, op, fldPath, obj, oldObj, false, "T1.I1")...)
			return
		}(fldPath.Child("i1"), &obj.I1, safe.Field(oldObj, func(oldObj *T1) *int { return &oldObj.I1 }))...)

	// field T1.PI1
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *int) (errs field.ErrorList) {
			errs = append(errs, validate.FixedResult[*int](ctx, op, fldPath, obj, oldObj, true, "T1.PI1")...)
			return
		}(fldPath.Child("pi1"), obj.PI1, safe.Field(oldObj, func(oldObj *T1) *int { return oldObj.PI1 }))...)

	return errs
}
