// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) conf: crate::Config,
    #[allow(dead_code)] // unused when a service does not provide any operations
    pub(crate) runtime_plugins: ::aws_smithy_runtime_api::client::runtime_plugin::RuntimePlugins,
}

/// Client for Amazon Simple Storage Service
///
/// Client for invoking operations on Amazon Simple Storage Service. Each operation on Amazon Simple Storage Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
/// ## Constructing a `Client`
///
/// A [`Config`] is required to construct a client. For most use cases, the [`aws-config`]
/// crate should be used to automatically resolve this config using
/// [`aws_config::load_from_env()`], since this will resolve an [`SdkConfig`] which can be shared
/// across multiple different AWS SDK clients. This config resolution process can be customized
/// by calling [`aws_config::from_env()`] instead, which returns a [`ConfigLoader`] that uses
/// the [builder pattern] to customize the default config.
///
/// In the simplest case, creating a client looks as follows:
/// ```rust,no_run
/// # async fn wrapper() {
/// let config = aws_config::load_from_env().await;
/// let client = aws_sdk_s3::Client::new(&config);
/// # }
/// ```
///
/// Occasionally, SDKs may have additional service-specific values that can be set on the [`Config`] that
/// is absent from [`SdkConfig`], or slightly different settings for a specific client may be desired.
/// The [`Builder`](crate::config::Builder) struct implements `From<&SdkConfig>`, so setting these specific settings can be
/// done as follows:
///
/// ```rust,no_run
/// # async fn wrapper() {
/// let sdk_config = ::aws_config::load_from_env().await;
/// let config = aws_sdk_s3::config::Builder::from(&sdk_config)
/// # /*
///     .some_service_specific_setting("value")
/// # */
///     .build();
/// # }
/// ```
///
/// See the [`aws-config` docs] and [`Config`] for more information on customizing configuration.
///
/// _Note:_ Client construction is expensive due to connection thread pool initialization, and should
/// be done once at application start-up.
///
/// [`Config`]: crate::Config
/// [`ConfigLoader`]: https://docs.rs/aws-config/*/aws_config/struct.ConfigLoader.html
/// [`SdkConfig`]: https://docs.rs/aws-config/*/aws_config/struct.SdkConfig.html
/// [`aws-config` docs]: https://docs.rs/aws-config/*
/// [`aws-config`]: https://crates.io/crates/aws-config
/// [`aws_config::from_env()`]: https://docs.rs/aws-config/*/aws_config/fn.from_env.html
/// [`aws_config::load_from_env()`]: https://docs.rs/aws-config/*/aws_config/fn.load_from_env.html
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#builders-enable-construction-of-complex-values-c-builder
/// # Using the `Client`
///
/// A client has a function for every operation that can be performed by the service.
/// For example, the [`AbortMultipartUpload`](crate::operation::abort_multipart_upload) operation has
/// a [`Client::abort_multipart_upload`], function which returns a builder for that operation.
/// The fluent builder ultimately has a `send()` function that returns an async future that
/// returns a result, as illustrated below:
///
/// ```rust,ignore
/// let result = client.abort_multipart_upload()
///     .bucket("example")
///     .send()
///     .await;
/// ```
///
/// The underlying HTTP requests that get made by this can be modified with the `customize_operation`
/// function on the fluent builder. See the [`customize`](crate::client::customize) module for more
/// information.
/// # Waiters
///
/// This client provides `wait_until` methods behind the [`Waiters`](crate::client::Waiters) trait.
/// To use them, simply import the trait, and then call one of the `wait_until` methods. This will
/// return a waiter fluent builder that takes various parameters, which are documented on the builder
/// type. Once parameters have been provided, the `wait` method can be called to initiate waiting.
///
/// For example, if there was a `wait_until_thing` method, it could look like:
/// ```rust,ignore
/// let result = client.wait_until_thing()
///     .thing_id("someId")
///     .wait(Duration::from_secs(120))
///     .await;
/// ```
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct Client {
    handle: ::std::sync::Arc<Handle>,
}

impl Client {
    /// Creates a new client from the service [`Config`](crate::Config).
    ///
    /// # Panics
    ///
    /// This method will panic in the following cases:
    ///
    /// - Retries or timeouts are enabled without a `sleep_impl` configured.
    /// - Identity caching is enabled without a `sleep_impl` and `time_source` configured.
    /// - No `behavior_version` is provided.
    ///
    /// The panic message for each of these will have instructions on how to resolve them.
    #[track_caller]
    pub fn from_conf(conf: crate::Config) -> Self {
        let handle = Handle {
            conf: conf.clone(),
            runtime_plugins: crate::config::base_client_runtime_plugins(conf),
        };
        if let Err(err) = Self::validate_config(&handle) {
            panic!("Invalid client configuration: {err}");
        }
        Self {
            handle: ::std::sync::Arc::new(handle),
        }
    }

    /// Returns the client's configuration.
    pub fn config(&self) -> &crate::Config {
        &self.handle.conf
    }

    fn validate_config(handle: &Handle) -> ::std::result::Result<(), ::aws_smithy_runtime_api::box_error::BoxError> {
        let mut cfg = ::aws_smithy_types::config_bag::ConfigBag::base();
        handle
            .runtime_plugins
            .apply_client_configuration(&mut cfg)?
            .validate_base_client_config(&cfg)?;
        Ok(())
    }
}

///
/// Waiter functions for the client.
///
/// Import this trait to get `wait_until` methods on the client.
///
pub trait Waiters {
    /// Wait for `bucket_exists`
    fn wait_until_bucket_exists(&self) -> crate::waiters::bucket_exists::BucketExistsFluentBuilder;
    /// Wait for `bucket_not_exists`
    fn wait_until_bucket_not_exists(&self) -> crate::waiters::bucket_not_exists::BucketNotExistsFluentBuilder;
    /// Wait for `object_exists`
    fn wait_until_object_exists(&self) -> crate::waiters::object_exists::ObjectExistsFluentBuilder;
    /// Wait for `object_not_exists`
    fn wait_until_object_not_exists(&self) -> crate::waiters::object_not_exists::ObjectNotExistsFluentBuilder;
}
impl Waiters for Client {
    fn wait_until_bucket_exists(&self) -> crate::waiters::bucket_exists::BucketExistsFluentBuilder {
        crate::waiters::bucket_exists::BucketExistsFluentBuilder::new(self.handle.clone())
    }
    fn wait_until_bucket_not_exists(&self) -> crate::waiters::bucket_not_exists::BucketNotExistsFluentBuilder {
        crate::waiters::bucket_not_exists::BucketNotExistsFluentBuilder::new(self.handle.clone())
    }
    fn wait_until_object_exists(&self) -> crate::waiters::object_exists::ObjectExistsFluentBuilder {
        crate::waiters::object_exists::ObjectExistsFluentBuilder::new(self.handle.clone())
    }
    fn wait_until_object_not_exists(&self) -> crate::waiters::object_not_exists::ObjectNotExistsFluentBuilder {
        crate::waiters::object_not_exists::ObjectNotExistsFluentBuilder::new(self.handle.clone())
    }
}

impl Client {
    /// Creates a new client from an [SDK Config](::aws_types::sdk_config::SdkConfig).
    ///
    /// # Panics
    ///
    /// - This method will panic if the `sdk_config` is missing an async sleep implementation. If you experience this panic, set
    ///   the `sleep_impl` on the Config passed into this function to fix it.
    /// - This method will panic if the `sdk_config` is missing an HTTP connector. If you experience this panic, set the
    ///   `http_connector` on the Config passed into this function to fix it.
    /// - This method will panic if no `BehaviorVersion` is provided. If you experience this panic, set `behavior_version` on the Config or enable the `behavior-version-latest` Cargo feature.
    #[track_caller]
    pub fn new(sdk_config: &::aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }
}

mod abort_multipart_upload;

mod complete_multipart_upload;

mod copy_object;

mod create_bucket;

mod create_bucket_metadata_configuration;

mod create_bucket_metadata_table_configuration;

mod create_multipart_upload;

mod create_session;

/// Operation customization and supporting types.
///
/// The underlying HTTP requests made during an operation can be customized
/// by calling the `customize()` method on the builder returned from a client
/// operation call. For example, this can be used to add an additional HTTP header:
///
/// ```ignore
/// # async fn wrapper() -> ::std::result::Result<(), aws_sdk_s3::Error> {
/// # let client: aws_sdk_s3::Client = unimplemented!();
/// use ::http::header::{HeaderName, HeaderValue};
///
/// let result = client.abort_multipart_upload()
///     .customize()
///     .mutate_request(|req| {
///         // Add `x-example-header` with value
///         req.headers_mut()
///             .insert(
///                 HeaderName::from_static("x-example-header"),
///                 HeaderValue::from_static("1"),
///             );
///     })
///     .send()
///     .await;
/// # }
/// ```
pub mod customize;

mod delete_bucket;

mod delete_bucket_analytics_configuration;

mod delete_bucket_cors;

mod delete_bucket_encryption;

mod delete_bucket_intelligent_tiering_configuration;

mod delete_bucket_inventory_configuration;

mod delete_bucket_lifecycle;

mod delete_bucket_metadata_configuration;

mod delete_bucket_metadata_table_configuration;

mod delete_bucket_metrics_configuration;

mod delete_bucket_ownership_controls;

mod delete_bucket_policy;

mod delete_bucket_replication;

mod delete_bucket_tagging;

mod delete_bucket_website;

mod delete_object;

mod delete_object_tagging;

mod delete_objects;

mod delete_public_access_block;

mod get_bucket_accelerate_configuration;

mod get_bucket_acl;

mod get_bucket_analytics_configuration;

mod get_bucket_cors;

mod get_bucket_encryption;

mod get_bucket_intelligent_tiering_configuration;

mod get_bucket_inventory_configuration;

mod get_bucket_lifecycle_configuration;

mod get_bucket_location;

mod get_bucket_logging;

mod get_bucket_metadata_configuration;

mod get_bucket_metadata_table_configuration;

mod get_bucket_metrics_configuration;

mod get_bucket_notification_configuration;

mod get_bucket_ownership_controls;

mod get_bucket_policy;

mod get_bucket_policy_status;

mod get_bucket_replication;

mod get_bucket_request_payment;

mod get_bucket_tagging;

mod get_bucket_versioning;

mod get_bucket_website;

mod get_object;

mod get_object_acl;

mod get_object_attributes;

mod get_object_legal_hold;

mod get_object_lock_configuration;

mod get_object_retention;

mod get_object_tagging;

mod get_object_torrent;

mod get_public_access_block;

mod head_bucket;

mod head_object;

mod list_bucket_analytics_configurations;

mod list_bucket_intelligent_tiering_configurations;

mod list_bucket_inventory_configurations;

mod list_bucket_metrics_configurations;

mod list_buckets;

mod list_directory_buckets;

mod list_multipart_uploads;

mod list_object_versions;

mod list_objects;

mod list_objects_v2;

mod list_parts;

mod put_bucket_accelerate_configuration;

mod put_bucket_acl;

mod put_bucket_analytics_configuration;

mod put_bucket_cors;

mod put_bucket_encryption;

mod put_bucket_intelligent_tiering_configuration;

mod put_bucket_inventory_configuration;

mod put_bucket_lifecycle_configuration;

mod put_bucket_logging;

mod put_bucket_metrics_configuration;

mod put_bucket_notification_configuration;

mod put_bucket_ownership_controls;

mod put_bucket_policy;

mod put_bucket_replication;

mod put_bucket_request_payment;

mod put_bucket_tagging;

mod put_bucket_versioning;

mod put_bucket_website;

mod put_object;

mod put_object_acl;

mod put_object_legal_hold;

mod put_object_lock_configuration;

mod put_object_retention;

mod put_object_tagging;

mod put_public_access_block;

mod rename_object;

mod restore_object;

mod select_object_content;

mod update_bucket_metadata_inventory_table_configuration;

mod update_bucket_metadata_journal_table_configuration;

mod upload_part;

mod upload_part_copy;

mod write_get_object_response;
