/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class MessageDialogWithLink
extends MessageDialog {
    protected String linkMessage;
    protected Link link;
    protected List<SelectionListener> linkListeners = new ArrayList<SelectionListener>();

    public MessageDialogWithLink(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.message = null;
        this.linkMessage = dialogMessage;
    }

    public MessageDialogWithLink(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, int defaultIndex, String ... dialogButtonLabels) {
        this(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
    }

    protected Control createMessageArea(Composite composite) {
        super.createMessageArea(composite);
        if (this.linkMessage != null) {
            this.link = new Link(composite, this.getMessageLabelStyle());
            this.link.setText(this.linkMessage);
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)this.link);
            for (SelectionListener linkListener : this.linkListeners) {
                this.link.addSelectionListener(linkListener);
            }
        }
        return composite;
    }

    public void addSelectionListener(SelectionListener listener) {
        if (this.link != null && !this.link.isDisposed()) {
            this.link.addSelectionListener(listener);
        }
        this.linkListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (this.link != null && !this.link.isDisposed()) {
            this.link.removeSelectionListener(listener);
        }
        this.linkListeners.add(listener);
    }
}

