/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.voice.internal.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.Metadata;
import org.openhab.core.items.MetadataKey;
import org.openhab.core.items.MetadataRegistry;
import org.openhab.core.library.types.HSBType;
import org.openhab.core.library.types.IncreaseDecreaseType;
import org.openhab.core.library.types.NextPreviousType;
import org.openhab.core.library.types.OnOffType;
import org.openhab.core.library.types.PlayPauseType;
import org.openhab.core.library.types.RewindFastforwardType;
import org.openhab.core.library.types.StopMoveType;
import org.openhab.core.library.types.UpDownType;
import org.openhab.core.types.Command;
import org.openhab.core.types.CommandDescription;
import org.openhab.core.types.RefreshType;
import org.openhab.core.types.StateDescription;
import org.openhab.core.types.TypeParser;
import org.openhab.core.voice.text.AbstractRuleBasedInterpreter;
import org.openhab.core.voice.text.Expression;
import org.openhab.core.voice.text.ExpressionAlternatives;
import org.openhab.core.voice.text.ExpressionCardinality;
import org.openhab.core.voice.text.HumanLanguageInterpreter;
import org.openhab.core.voice.text.Rule;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={HumanLanguageInterpreter.class})
public class StandardInterpreter
extends AbstractRuleBasedInterpreter {
    public static final String VOICE_SYSTEM_NAMESPACE = "voiceSystem";
    private Logger logger = LoggerFactory.getLogger(StandardInterpreter.class);
    private final ItemRegistry itemRegistry;
    private final MetadataRegistry metadataRegistry;

    @Activate
    public StandardInterpreter(@Reference EventPublisher eventPublisher, @Reference ItemRegistry itemRegistry, @Reference MetadataRegistry metadataRegistry) {
        super(eventPublisher, itemRegistry, metadataRegistry);
        this.itemRegistry = itemRegistry;
        this.metadataRegistry = metadataRegistry;
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
    }

    @Override
    public Set<Locale> getSupportedLocales() {
        return Set.of(Locale.ENGLISH, Locale.GERMAN, Locale.FRENCH, Locale.of("es"));
    }

    @Override
    public void createRules(@Nullable Locale locale) {
        if (locale == null || Objects.equals(locale.getLanguage(), Locale.ENGLISH.getLanguage())) {
            ExpressionAlternatives onOff = this.alt(this.cmd((Object)"on", (Command)OnOffType.ON), this.cmd((Object)"off", (Command)OnOffType.OFF));
            ExpressionAlternatives turn = this.alt("turn", "switch");
            ExpressionAlternatives put = this.alt("put", "bring");
            ExpressionCardinality of = this.opt("of");
            ExpressionCardinality the = this.opt("the");
            ExpressionCardinality to = this.opt("to");
            ExpressionAlternatives color = this.alt(this.cmd((Object)"white", (Command)HSBType.WHITE), this.cmd((Object)"pink", (Command)HSBType.fromRGB((int)255, (int)96, (int)208)), this.cmd((Object)"yellow", (Command)HSBType.fromRGB((int)255, (int)224, (int)32)), this.cmd((Object)"orange", (Command)HSBType.fromRGB((int)255, (int)160, (int)16)), this.cmd((Object)"purple", (Command)HSBType.fromRGB((int)128, (int)0, (int)128)), this.cmd((Object)"red", (Command)HSBType.RED), this.cmd((Object)"green", (Command)HSBType.GREEN), this.cmd((Object)"blue", (Command)HSBType.BLUE));
            this.addRules(Locale.ENGLISH, this.itemRule(this.seq(turn, the), onOff), this.itemRule(this.seq(turn, onOff)), this.itemRule(this.seq(this.cmd((Object)this.alt("dim", "decrease", "lower", "soften"), (Command)IncreaseDecreaseType.DECREASE), the)), this.itemRule(this.seq(this.cmd((Object)this.alt("brighten", "increase", "harden", "enhance"), (Command)IncreaseDecreaseType.INCREASE), the)), this.itemRule(this.seq(this.opt("set"), the, this.opt("color"), of, the), this.seq(to, color)), this.itemRule(this.seq(put, the), this.cmd((Object)"up", (Command)UpDownType.UP)), this.itemRule(this.seq(put, the), this.cmd((Object)"down", (Command)UpDownType.DOWN)), this.itemRule("move", this.seq(this.opt("to"), this.alt(this.cmd((Object)"next", (Command)NextPreviousType.NEXT), this.cmd((Object)"previous", (Command)NextPreviousType.PREVIOUS)))), this.itemRule(this.seq(this.cmd((Object)"play", (Command)PlayPauseType.PLAY), the)), this.itemRule(this.seq(this.cmd((Object)"pause", (Command)PlayPauseType.PAUSE), the)), this.itemRule(this.seq(this.cmd((Object)"rewind", (Command)RewindFastforwardType.REWIND), the)), this.itemRule(this.seq(this.cmd((Object)this.seq(this.opt("fast"), "forward"), (Command)RewindFastforwardType.FASTFORWARD), the)), this.itemRule(this.seq(this.cmd((Object)"stop", (Command)StopMoveType.STOP), the)), this.itemRule(this.seq(this.cmd((Object)this.alt("start", "move", "continue"), (Command)StopMoveType.MOVE), the)), this.itemRule(this.seq(this.cmd((Object)"refresh", (Command)RefreshType.REFRESH), the)));
            this.addRules(Locale.ENGLISH, (Rule[])this.createItemDescriptionRules((allowedItems, labeledCmd) -> this.restrictedItemRule(allowedItems, this.seq(this.alt("set", "change"), this.opt(the)), this.seq(to, labeledCmd)), Locale.ENGLISH).toArray(Rule[]::new));
        }
        if (locale == null || Objects.equals(locale.getLanguage(), Locale.GERMAN.getLanguage())) {
            ExpressionAlternatives einAnAus = this.alt(this.cmd((Object)"ein", (Command)OnOffType.ON), this.cmd((Object)"an", (Command)OnOffType.ON), this.cmd((Object)"aus", (Command)OnOffType.OFF));
            ExpressionCardinality denDieDas = this.opt(this.alt("den", "die", "das"));
            ExpressionAlternatives schalte = this.alt("schalt", "schalte", "mach");
            ExpressionAlternatives pause = this.alt("pause", "stoppe");
            ExpressionAlternatives mache = this.alt("mach", "mache", "fahre");
            ExpressionAlternatives spiele = this.alt("spiele", "spiel", "starte");
            ExpressionAlternatives zu = this.alt("zu", "zum", "zur");
            ExpressionCardinality the = this.opt("the");
            ExpressionAlternatives naechste = this.alt("n\u00e4chste", "n\u00e4chstes", "n\u00e4chster");
            ExpressionAlternatives vorherige = this.alt("vorherige", "vorheriges", "vorheriger");
            ExpressionAlternatives farbe = this.alt(this.cmd((Object)"wei\u00df", (Command)HSBType.WHITE), this.cmd((Object)"pink", (Command)HSBType.fromRGB((int)255, (int)96, (int)208)), this.cmd((Object)"gelb", (Command)HSBType.fromRGB((int)255, (int)224, (int)32)), this.cmd((Object)"orange", (Command)HSBType.fromRGB((int)255, (int)160, (int)16)), this.cmd((Object)"lila", (Command)HSBType.fromRGB((int)128, (int)0, (int)128)), this.cmd((Object)"rot", (Command)HSBType.RED), this.cmd((Object)"gr\u00fcn", (Command)HSBType.GREEN), this.cmd((Object)"blau", (Command)HSBType.BLUE));
            this.addRules(Locale.GERMAN, this.itemRule(this.seq(schalte, denDieDas), einAnAus), this.itemRule(this.seq(this.cmd((Object)this.alt("dimme"), (Command)IncreaseDecreaseType.DECREASE), denDieDas)), this.itemRule(this.seq(schalte, denDieDas), this.cmd((Object)this.alt("dunkler", "weniger"), (Command)IncreaseDecreaseType.DECREASE)), this.itemRule(this.seq(schalte, denDieDas), this.cmd((Object)this.alt("heller", "mehr"), (Command)IncreaseDecreaseType.INCREASE)), this.itemRule(this.seq(schalte, denDieDas), this.seq(this.opt("auf"), farbe)), this.itemRule(this.seq(mache, denDieDas), this.cmd((Object)"hoch", (Command)UpDownType.UP)), this.itemRule(this.seq(mache, denDieDas), this.cmd((Object)"runter", (Command)UpDownType.DOWN)), this.itemRule("wechsle", this.seq(this.opt(zu), this.alt(this.cmd((Object)naechste, (Command)NextPreviousType.NEXT), this.cmd((Object)vorherige, (Command)NextPreviousType.PREVIOUS)))), this.itemRule(this.seq(this.cmd((Object)spiele, (Command)PlayPauseType.PLAY), the)), this.itemRule(this.seq(this.cmd((Object)pause, (Command)PlayPauseType.PAUSE), the)));
            this.addRules(Locale.GERMAN, (Rule[])this.createItemDescriptionRules((allowedItems, labeledCmd) -> this.restrictedItemRule(allowedItems, this.seq(schalte, denDieDas), this.seq(this.opt("auf"), labeledCmd)), Locale.GERMAN).toArray(Rule[]::new));
        }
        if (locale == null || Objects.equals(locale.getLanguage(), Locale.FRENCH.getLanguage())) {
            ExpressionAlternatives allume = this.alt("allume", "d\u00e9marre", "active");
            ExpressionAlternatives eteins = this.alt("\u00e9teins", "stoppe", "d\u00e9sactive", "coupe");
            ExpressionCardinality lela = this.opt(this.alt("le", "la", "les", "l"));
            ExpressionCardinality poursurdude = this.opt(this.alt("pour", "sur", "du", "de"));
            ExpressionAlternatives couleur = this.alt(this.cmd((Object)"blanc", (Command)HSBType.WHITE), this.cmd((Object)"rose", (Command)HSBType.fromRGB((int)255, (int)96, (int)208)), this.cmd((Object)"jaune", (Command)HSBType.fromRGB((int)255, (int)224, (int)32)), this.cmd((Object)"orange", (Command)HSBType.fromRGB((int)255, (int)160, (int)16)), this.cmd((Object)"violet", (Command)HSBType.fromRGB((int)128, (int)0, (int)128)), this.cmd((Object)"rouge", (Command)HSBType.RED), this.cmd((Object)"vert", (Command)HSBType.GREEN), this.cmd((Object)"bleu", (Command)HSBType.BLUE));
            this.addRules(Locale.FRENCH, this.itemRule(this.seq(this.cmd((Object)allume, (Command)OnOffType.ON), lela)), this.itemRule(this.seq(this.cmd((Object)eteins, (Command)OnOffType.OFF), lela)), this.itemRule(this.seq(this.cmd((Object)"augmente", (Command)IncreaseDecreaseType.INCREASE), lela)), this.itemRule(this.seq(this.cmd((Object)"diminue", (Command)IncreaseDecreaseType.DECREASE), lela)), this.itemRule(this.seq(this.cmd((Object)"plus", (Command)IncreaseDecreaseType.INCREASE), "de")), this.itemRule(this.seq(this.cmd((Object)"moins", (Command)IncreaseDecreaseType.DECREASE), "de")), this.itemRule(this.seq("couleur", couleur, this.opt("pour"), lela)), this.itemRule(this.seq(this.cmd((Object)"reprise", (Command)PlayPauseType.PLAY), "lecture", poursurdude, lela)), this.itemRule(this.seq(this.cmd((Object)"pause", (Command)PlayPauseType.PAUSE), "lecture", poursurdude, lela)), this.itemRule(this.seq(this.alt("plage", "piste"), this.alt(this.cmd((Object)"suivante", (Command)NextPreviousType.NEXT), this.cmd((Object)"pr\u00e9c\u00e9dente", (Command)NextPreviousType.PREVIOUS)), poursurdude, lela)), this.itemRule(this.seq(this.cmd((Object)"monte", (Command)UpDownType.UP), lela)), this.itemRule(this.seq(this.cmd((Object)"descends", (Command)UpDownType.DOWN), lela)), this.itemRule(this.seq(this.cmd((Object)"arr\u00eate", (Command)StopMoveType.STOP), lela)), this.itemRule(this.seq(this.cmd((Object)this.alt("bouge", "d\u00e9place"), (Command)StopMoveType.MOVE), lela)), this.itemRule(this.seq(this.cmd((Object)"rafra\u00eechis", (Command)RefreshType.REFRESH), lela)));
            this.addRules(Locale.FRENCH, (Rule[])this.createItemDescriptionRules((allowedItems, labeledCmd) -> this.restrictedItemRule(allowedItems, this.seq("mets", lela), this.seq(poursurdude, lela, labeledCmd)), Locale.FRENCH).toArray(Rule[]::new));
        }
        Locale localeES = Locale.of("es");
        if (locale == null || Objects.equals(locale.getLanguage(), localeES.getLanguage())) {
            ExpressionAlternatives encenderApagar = this.alt(this.cmd((Object)this.alt("enciende", "encender"), (Command)OnOffType.ON), this.cmd((Object)this.alt("apaga", "apagar"), (Command)OnOffType.OFF));
            ExpressionAlternatives cambiar = this.alt("cambia", "cambiar");
            ExpressionAlternatives poner = this.alt("pon", "poner");
            ExpressionCardinality preposicion = this.opt(this.alt("a", "de", "en"));
            ExpressionCardinality articulo = this.opt(this.alt("el", "la", "los", "las"));
            ExpressionAlternatives nombreColor = this.alt(this.cmd((Object)"blanco", (Command)HSBType.WHITE), this.cmd((Object)"rosa", (Command)HSBType.fromRGB((int)255, (int)96, (int)208)), this.cmd((Object)"amarillo", (Command)HSBType.fromRGB((int)255, (int)224, (int)32)), this.cmd((Object)"naranja", (Command)HSBType.fromRGB((int)255, (int)160, (int)16)), this.cmd((Object)"p\u00farpura", (Command)HSBType.fromRGB((int)128, (int)0, (int)128)), this.cmd((Object)"rojo", (Command)HSBType.RED), this.cmd((Object)"verde", (Command)HSBType.GREEN), this.cmd((Object)"azul", (Command)HSBType.BLUE));
            this.addRules(localeES, this.itemRule(this.seq(encenderApagar, articulo)), this.itemRule(this.seq(this.cmd((Object)this.alt("baja", "suaviza", "bajar", "suavizar"), (Command)IncreaseDecreaseType.DECREASE), articulo)), this.itemRule(this.seq(this.cmd((Object)this.alt("sube", "aumenta", "subir", "aumentar"), (Command)IncreaseDecreaseType.INCREASE), articulo)), this.itemRule(this.seq(cambiar, articulo, this.opt("color"), preposicion, articulo), this.seq(this.opt("a"), nombreColor)), this.itemRule(this.seq(poner, articulo), this.cmd((Object)"arriba", (Command)UpDownType.UP)), this.itemRule(this.seq(poner, articulo), this.cmd((Object)"abajo", (Command)UpDownType.DOWN)), this.itemRule(this.seq(cambiar, this.opt(articulo)), this.seq(this.opt("a"), this.alt(this.cmd((Object)"siguiente", (Command)NextPreviousType.NEXT), this.cmd((Object)"anterior", (Command)NextPreviousType.PREVIOUS)))), this.itemRule(this.seq(this.opt(poner), this.alt(this.cmd((Object)"siguiente", (Command)NextPreviousType.NEXT), this.cmd((Object)"anterior", (Command)NextPreviousType.PREVIOUS)), "en"), this.opt(articulo)), this.itemRule(this.seq(this.cmd((Object)this.alt("continuar", "contin\u00faa", "reanudar", "reanuda", "play"), (Command)PlayPauseType.PLAY), this.alt(articulo, "en"))), this.itemRule(this.seq(this.cmd((Object)this.alt("pausa", "pausar", "det\u00e9n", "detener"), (Command)PlayPauseType.PAUSE), this.alt(articulo, "en"))), this.itemRule(this.seq(this.cmd((Object)this.alt("rebobina", "rebobinar"), (Command)RewindFastforwardType.REWIND), this.alt(articulo, "en"))), this.itemRule(this.seq(this.cmd((Object)this.alt("avanza", "avanzar"), (Command)RewindFastforwardType.FASTFORWARD), this.alt(articulo, "en"))), this.itemRule(this.seq(this.cmd((Object)this.alt("para", "parar", "stop"), (Command)StopMoveType.STOP), articulo)), this.itemRule(this.seq(this.cmd((Object)this.alt("mueve", "mover"), (Command)StopMoveType.MOVE), articulo)), this.itemRule(this.seq(this.cmd((Object)this.alt("recarga", "refresca", "recargar", "refrescar"), (Command)RefreshType.REFRESH), articulo)));
            this.addRules(localeES, (Rule[])this.createItemDescriptionRules((allowedItems, labeledCmd) -> this.restrictedItemRule(allowedItems, this.seq(this.alt(cambiar, poner), this.opt(articulo)), this.seq(preposicion, labeledCmd)), localeES).toArray(Rule[]::new));
        }
    }

    @Override
    public String getId() {
        return "system";
    }

    @Override
    public String getLabel(@Nullable Locale locale) {
        return "Built-in Interpreter";
    }

    private List<Rule> createItemDescriptionRules(CreateItemDescriptionRule creator, Locale locale) {
        HashMap options = new HashMap();
        ArrayList<Rule> customRules = new ArrayList<Rule>();
        for (Item item : this.itemRegistry.getItems()) {
            CommandDescription commandDesc;
            customRules.addAll(this.createItemMetadataRules(locale, item));
            StateDescription stateDesc = item.getStateDescription(locale);
            if (stateDesc != null) {
                stateDesc.getOptions().forEach(op -> {
                    String label = op.getLabel();
                    if (label == null || label.isBlank()) {
                        label = op.getValue();
                    }
                    HashMap<Item, String> optionValueByItem = options.getOrDefault(label, new HashMap());
                    optionValueByItem.put(item, op.getValue());
                    options.put(label, optionValueByItem);
                });
            }
            if ((commandDesc = item.getCommandDescription(locale)) == null) continue;
            commandDesc.getCommandOptions().forEach(op -> {
                String label = op.getLabel();
                if (label == null || label.isBlank()) {
                    label = op.getCommand();
                }
                HashMap<Item, String> optionValueByItem = options.getOrDefault(label, new HashMap());
                optionValueByItem.put(item, op.getCommand());
                options.put(label, optionValueByItem);
            });
        }
        return Stream.concat(customRules.stream(), options.entrySet().stream().map(entry -> {
            String label = (String)entry.getKey();
            Map commandByItem = (Map)entry.getValue();
            Object[] labelParts = (String[])Arrays.stream(label.split("\\s")).filter(p -> !p.isBlank()).toArray(String[]::new);
            Expression labeledCmd = this.cmd((Object)this.seq(labelParts), new ItemStateCommandSupplier(label, commandByItem));
            return creator.itemDescriptionRule(commandByItem.keySet(), labeledCmd);
        })).collect(Collectors.toList());
    }

    private List<Rule> createItemMetadataRules(Locale locale, Item item) {
        Metadata interpreterMetadata = (Metadata)this.metadataRegistry.get((Object)new MetadataKey(VOICE_SYSTEM_NAMESPACE, item.getName()));
        if (interpreterMetadata == null) {
            return List.of();
        }
        return Arrays.stream(interpreterMetadata.getValue().split("\n")).map(line -> this.parseItemCustomRules(locale, item, line.trim(), interpreterMetadata)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static interface CreateItemDescriptionRule {
        public Rule itemDescriptionRule(Set<Item> var1, Expression var2);
    }

    private record ItemStateCommandSupplier(String label, Map<Item, String> commandByItem) implements AbstractRuleBasedInterpreter.ItemCommandSupplier
    {
        @Override
        public @Nullable Command getItemCommand(Item item) {
            String textCommand = this.commandByItem.get(item);
            if (textCommand == null) {
                return null;
            }
            return TypeParser.parseCommand((List)item.getAcceptedCommandTypes(), (String)textCommand);
        }

        @Override
        public String getCommandLabel() {
            return this.label;
        }

        @Override
        public List<Class<? extends Command>> getCommandClasses(@Nullable Item item) {
            if (item == null) {
                return this.commandByItem.keySet().stream().flatMap(i -> i.getAcceptedCommandTypes().stream()).distinct().collect(Collectors.toList());
            }
            if (this.commandByItem.containsKey(item)) {
                return item.getAcceptedCommandTypes();
            }
            return List.of();
        }
    }
}

